<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Services\WhatsAppApiService;
use Illuminate\Http\JsonResponse;
use Illuminate\View\View;
use Exception;
use Illuminate\Support\Facades\Log;

class AuthController extends Controller
{
    protected WhatsAppApiService $whatsappService;

    public function __construct(WhatsAppApiService $whatsappService)
    {
       $this->whatsappApi = $whatsappService;
    }

    /**
     * Show the QR code page.
     *
     * @return \Illuminate\View\View
     */
    public function showQr(): View
    {
        return view('auth.qr');
    }

    /**
     * Get the QR code data from the API.
     *
     * @return \Illuminate\Http\JsonResponse
     */
    public function getQrCode(): JsonResponse
    {
        try {
            $response =$this->whatsappApi->getQrCode();
            return response()->json(['qr' => $response]);
        } catch (Exception $e) {
            return response()->json(['error' => 'Failed to fetch QR code.', 'message' => $e->getMessage()], 500);
        }
    }
   
    // login methods would go here
    public function login()
    {
        // Login logic to be implemented
        
    }
}